/* SigmaStar trade secret */
/* Copyright (c) [2019~2020] SigmaStar Technology.
All rights reserved.

Unless otherwise stipulated in writing, any and all information contained
herein regardless in any format shall remain the sole proprietary of
SigmaStar and be kept in strict confidence
(SigmaStar Confidential Information) by the recipient.
Any unauthorized act including without limitation unauthorized disclosure,
copying, use, reproduction, sale, distribution, modification, disassembling,
reverse engineering and compiling of the contents of SigmaStar Confidential
Information is unlawful and strictly prohibited. SigmaStar hereby reserves the
rights to any and all damages, losses, costs and expenses resulting therefrom.
*/


#ifndef __CAM_PROC_COMMON_H__
#define __CAM_PROC_COMMON_H__

#if defined (__KERNEL__)
#include <linux/seq_file.h>
#endif

#include "cam_os_util_list.h"
#include "cam_proc_wrapper.h"

#ifdef CAM_OS_RTK
typedef struct {
    struct CamOsListHead_t link;
    char aEntryName[16];
    struct CamOsListHead_t sSubNodeList;
    CamProcCatCB pfCatCB;
    CamProcEchoCB pfEchoCB;
} CamProcEntry_t;

#elif defined (__KERNEL__)
typedef struct
{
    void (*cat)(CamProcSeqBuf_t*, int);
    void (*echo)(char*, int);
} CamProcNodeOp_t ;

typedef struct {
    struct file_operations pFileOps;
    CamProcNodeOp_t sProcOps;
}CamProcPrivate_t;

typedef struct {
    struct CamOsListHead_t link;
    char aEntryName[16];
    struct CamOsListHead_t sSubNodeList;
    struct proc_dir_entry *pde;
    CamProcPrivate_t *pdata;
} CamProcEntry_t;
#endif

extern struct CamOsListHead_t _proc_root_list;

#endif /* __CAM_PROC_COMMON_H__ */
